--------------------------------------------------------------------------------
-- PROCEDURE NAME	: [GLog_TB_USER_Select], [GLog_TB_USER_Delete], [GLog_TB_USER_Insert]
-- DESC			: // 2011-12-12 by hskim, GLog 2
-- DESC			: GLog_TB_USER ̺  ν
--------------------------------------------------------------------------------
CREATE PROC [dbo].[GLog_TB_USER_Select]
AS
-- YD  ڵ
BEGIN
	SELECT TOP 1000 [UID], [us_id], [us_birthday], [us_sex], [us_regdate], [us_delete], [us_ip], [us_location], [us_country], [us_publisher] 
		FROM [GLog].[dbo].[GLog_TB_USER] WHERE [GLogUpdated] = 0
END
GO

CREATE PROC [dbo].[GLog_TB_USER_Delete]
	@i_UID		BIGINT
AS
-- YD  ڵ
BEGIN
	UPDATE [GLog].[dbo].[GLog_TB_USER] SET [GLogUpdated] = 1 WHERE [UID] = @i_UID
END
GO

CREATE PROC 
	@i_us_id		VARCHAR(255),
	@i_us_birthday	DATETIME,
	@i_us_sex		CHAR(1),
	@i_us_regdate	DATETIME,
	@i_us_delete	CHAR(1),
	@i_us_ip		VARCHAR(20),
	@i_us_location	VARCHAR(50),
	@i_us_country	VARCHAR(50),
	@i_us_publisher	VARCHAR(100)
AS
-- YD  ڵ
BEGIN
	INSERT INTO [GLog].[dbo].[GLog_TB_USER] ([us_id], [us_birthday], [us_sex], [us_regdate], [us_delete], [us_ip], [us_location], [us_country], [us_publisher])
		VALUES(@i_us_id, @i_us_birthday, @i_us_sex, @i_us_regdate, @i_us_delete, @i_us_ip, @i_us_location, @i_us_country, @i_us_publisher)
END
GO

CREATE PROCEDURE [dbo].[GLog_TB_USER_Insert]
	@i_AccountName				VARCHAR(20),
	@i_ServiceCountry			NVARCHAR(50),
	@i_GamePublisher			NVARCHAR(100),
	@i_IPAddress				NVARCHAR(20)
AS
	DECLARE @AccountName	 	NVARCHAR(128)
	SET @AccountName = (SELECT [us_id] FROM [GLog].[dbo].[GLog_TB_USER] WHERE [us_id] = @i_AccountName and [us_publisher] = @i_GamePublisher)

	IF (@AccountName IS NULL)
	BEGIN
		INSERT [GLog].[dbo].[GLog_TB_USER] ([us_id], [us_birthday], [us_sex], [us_regdate], [us_delete], [us_ip], [us_location], [us_country], [us_publisher]) 
			SELECT @i_AccountName, CAST(BirthYear AS NVARCHAR(64)), Sex-1, RegisteredDate, 0, @i_IPAddress, NULL, @i_ServiceCountry, @i_GamePublisher
				FROM atum2_db_account.dbo.td_account WHERE AccountName = @i_AccountName
	END  
GO

--------------------------------------------------------------------------------
-- PROCEDURE NAME	: [GLog_TB_CONNECT_USER_Select], [GLog_TB_CONNECT_USER_Delete], [GLog_TB_CONNECT_USER_Insert]
-- DESC			: // 2011-12-12 by hskim, GLog 2
-- DESC			: TB_CONNECT_USER ̺  ν
--------------------------------------------------------------------------------
CREATE PROC [dbo].[GLog_TB_CONNECT_USER_Select]
AS
-- YD  ڵ
BEGIN
	SELECT TOP 1000 [UID], [c_date], [c_world], [c_unique], [c_new], [c_times], [c_del], [c_gameserver], [c_publisher] 
		FROM [GLog].[dbo].[GLog_TB_CONNECT_USER]
END
GO

CREATE PROC [dbo].[GLog_TB_CONNECT_USER_Delete]
	@i_UID		BIGINT
AS
-- YD  ڵ
BEGIN
	DELETE FROM [GLog].[dbo].[GLog_TB_CONNECT_USER] WHERE [UID] = @i_UID
END
GO

CREATE PROC [dbo].[GLog_TB_CONNECT_USER_Insert]
	@i_c_date		SMALLDATETIME,
	@i_c_world		TINYINT,
	@i_c_unique		INT,
	@i_c_new		INT,
	@i_c_times		INT,
	@i_c_del		INT,
	@i_c_gameserver	VARCHAR(100),
	@i_c_publisher	VARCHAR(100)
AS
-- YD  ڵ
BEGIN
	INSERT INTO [GLog].[dbo].[GLog_TB_CONNECT_USER] ([c_date], [c_world], [c_unique], [c_new], [c_times], [c_del], [c_gameserver], [c_publisher])
		VALUES(@i_c_date, @i_c_world, @i_c_unique, @i_c_new, @i_c_times, @i_c_del, @i_c_gameserver, @i_c_publisher)
END
GO

--------------------------------------------------------------------------------
-- PROCEDURE NAME	: [GLog_TB_ITEM_BUY_Select], [GLog_TB_ITEM_BUY_Delete], [GLog_TB_ITEM_BUY_Insert]
-- DESC			: // 2011-12-12 by hskim, GLog 2
-- DESC			: TB_ITEM_BUY ̺  ν
--------------------------------------------------------------------------------
CREATE PROC [dbo].[GLog_TB_ITEM_BUY_Select]
AS
-- YD  ڵ
BEGIN
	SELECT TOP 1000 [UID], [ib_date], [ib_totalCost], [ib_CashCost], [us_no], [us_id], [ib_good_id], [ib_good_name], [ib_publisher], [ib_charName], [ib_charLevel], [ib_itemCount]
		FROM [GLog].[dbo].[GLog_TB_ITEM_BUY]
END
GO

CREATE PROC [dbo].[GLog_TB_ITEM_BUY_Delete]
	@i_UID		BIGINT
AS
-- YD  ڵ
BEGIN
	DELETE FROM [GLog].[dbo].[GLog_TB_ITEM_BUY] WHERE [UID] = @i_UID
END
GO

CREATE PROC [dbo].[GLog_TB_ITEM_BUY_Insert]
	@i_ib_date			DATETIME,
	@i_ib_totalCost		INT,
	@i_ib_CashCost		INT,
	@i_us_no			INT,
	@i_us_id			VARCHAR(255),
	@i_ib_good_id		INT,
	@i_ib_good_name		VARCHAR(128),
	@i_ib_publisher		VARCHAR(100),
	@i_ib_charName		VARCHAR(100),
	@i_ib_charLevel		INT,
	@i_ib_itemCount		INT
AS
-- YD  ڵ
BEGIN
	INSERT INTO [GLog].[dbo].[GLog_TB_ITEM_BUY] ([ib_date], [ib_totalCost], [ib_CashCost], [us_no], [us_id], [ib_good_id], [ib_good_name], [ib_publisher], [ib_charName], [ib_charLevel], [ib_itemCount])
		VALUES(@i_ib_date, @i_ib_totalCost, @i_ib_CashCost, @i_us_no, @i_us_id, @i_ib_good_id, @i_ib_good_name, @i_ib_publisher, @i_ib_charName, @i_ib_charLevel, @i_ib_itemCount)
END
GO

--------------------------------------------------------------------------------
-- PROCEDURE NAME	: [GLog_TB_CONCURRENT_USER_Select], [GLog_TB_CONCURRENT_USER_Delete], [GLog_TB_CONCURRENT_USER_Insert]
-- DESC			: // 2011-12-12 by hskim, GLog 2
-- DESC			: TB_CONCURRENT_USER ̺  ν
--------------------------------------------------------------------------------
CREATE PROC [dbo].[GLog_TB_CONCURRENT_USER_Select]
AS
-- YD  ڵ
BEGIN
	SELECT TOP 1000 [UID], [cu_world], [cu_date], [cu_count], [cu_publisher], [cu_gameServer]
		FROM [GLog].[dbo].[GLog_TB_CONCURRENT_USER]
END
GO

CREATE PROC [dbo].[GLog_TB_CONCURRENT_USER_Delete]
	@i_UID		BIGINT
AS
-- YD  ڵ
BEGIN
	DELETE FROM [GLog].[dbo].[GLog_TB_CONCURRENT_USER] WHERE [UID] = @i_UID
END
GO

CREATE PROC [dbo].[GLog_TB_CONCURRENT_USER_Insert]
	@i_cu_world			TINYINT,
	@i_cu_date			SMALLDATETIME,
	@i_cu_count			INT,
	@i_cu_publisher		VARCHAR(100),
	@i_cu_gameServer	VARCHAR(100)
AS
-- YD  ڵ
BEGIN
	INSERT INTO [GLog].[dbo].[GLog_TB_CONCURRENT_USER] ([cu_world], [cu_date], [cu_count], [cu_publisher], [cu_gameServer])
		VALUES(@i_cu_world, @i_cu_date, @i_cu_count, @i_cu_publisher, @i_cu_gameServer)
END
GO

--------------------------------------------------------------------------------
-- PROCEDURE NAME	: [GLog_TB_USER_PLAYTIME_Select], [GLog_TB_USER_PLAYTIME_Delete], [GLog_TB_USER_PLAYTIME_Insert]
-- DESC			: // 2011-12-12 by hskim, GLog 2
-- DESC			: TB_USER_PLAYTIME ̺  ν
--------------------------------------------------------------------------------
CREATE PROC [dbo].[GLog_TB_USER_PLAYTIME_Select]
AS
-- YD  ڵ
BEGIN
	SELECT TOP 1000 [UID], [up_login], [up_logout], [up_time], [us_no], [up_charID], [up_country], [up_race], [up_class], [up_exp]
		FROM [GLog].[dbo].[GLog_TB_USER_PLAYTIME]
END
GO

CREATE PROC [dbo].[GLog_TB_USER_PLAYTIME_Delete]
	@i_UID		BIGINT
AS
-- YD  ڵ
BEGIN
	DELETE FROM [GLog].[dbo].[GLog_TB_USER_PLAYTIME] WHERE [UID] = @i_UID
END
GO

CREATE PROC [dbo].[GLog_TB_USER_PLAYTIME_Insert]
	@i_up_login		DATETIME,
	@i_up_logout	DATETIME,
	@i_up_time		INT,
	@i_us_no		INT,
	@i_up_charID	INT,
	@i_up_country	CHAR(1),
	@i_up_race		CHAR(1),
	@i_up_class		CHAR(1),
	@i_up_exp		INT
AS
-- YD  ڵ
BEGIN
	INSERT INTO [GLog].[dbo].[GLog_TB_USER_PLAYTIME] ([up_login], [up_logout], [up_time], [us_no], [up_charID], [up_country], [up_race], [up_class], [up_exp])
		VALUES(@i_up_login, @i_up_logout, @i_up_time, @i_us_no, @i_up_charID, @i_up_country, @i_up_race, @i_up_class, @i_up_exp)
END
GO
